module RPG
  class Weapon
    def initialize
      @id = 0
      @name = ""
      @icon_name = ""
      @description = ""
      @animation1_id = 0
      @animation2_id = 0
      @price = 0
      @atk = 0
      @pdef = 0
      @mdef = 0
      @str_plus = 0
      @dex_plus = 0
      @agi_plus = 0
      @int_plus = 0
      @element_set = []
      @plus_state_set = []
      @minus_state_set = []
    end
    attr_accessor :id
    attr_accessor :name
    attr_accessor :icon_name
    attr_accessor :description
    attr_accessor :animation1_id
    attr_accessor :animation2_id
    attr_accessor :price
    attr_accessor :atk
    attr_accessor :pdef
    attr_accessor :mdef
    attr_accessor :str_plus
    attr_accessor :dex_plus
    attr_accessor :agi_plus
    attr_accessor :int_plus
    attr_accessor :element_set
    attr_accessor :plus_state_set
    attr_accessor :minus_state_set


    ###########################################
    # Ajouts aux classes
    ###########################################

    def to_dmk
      my = self.cast(My_RPG::My_Weapon)
      return my
    end


    def comparer(other)

      list_self = [
        @id,
        @name,
        @icon_name,
        @description,
        @animation1_id,
        @animation2_id,
        @price,
        @atk,
        @pdef,
        @mdef,
        @str_plus,
        @dex_plus,
        @agi_plus,
        @int_plus,
        @element_set,
        @plus_state_set,
        @minus_state_set
      ]


      list_other = [
        other.id,
        other.name,
        other.icon_name,
        other.description,
        other.animation1_id,
        other.animation2_id,
        other.price,
        other.atk,
        other.pdef,
        other.mdef,
        other.str_plus,
        other.dex_plus,
        other.agi_plus,
        other.int_plus,
        other.element_set,
        other.plus_state_set,
        other.minus_state_set
      ]

      
      if list_self != list_other
        raise(DMKW_DMK_Diff.new("Weapon.parameters"))
      end


      return true
    end


  end
end
